﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Langs" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.CRM" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Nota odsetkowa</title>
	<script runat="server" language="C#">

        public class Params : ContextBase
        {
            private Boolean kontoWirtualne;
            private Boolean zerowePozycje;


            public Params(Context ctx)
                : base(ctx)
            {
                kontoWirtualne = false;
                zerowePozycje = true;
            }


            [Priority(20)]
            [Caption("Rachunek wirtualny")]
            public Boolean KontoWirtualne
            {
                get { return kontoWirtualne; }
                set { kontoWirtualne = value; }
            }


            [Priority(40)]
            [Caption("Pozycje zerowe")]
            public Boolean ZerowePozycje
            {
                get { return zerowePozycje; }
                set { zerowePozycje = value; }
            }

            [Priority(99)]
            [Caption("Adres korespondencyjny")]
            public Boolean AdresKorespondencyjny { get; set; }
        }


        private Params prm;

        [Context]
        public Params Prm
        { set { prm = value; } }


        private String title;
        private Boolean first = true;

        private void OnContextLoad(Object sender, EventArgs args)
        {
            NotaOdsetkowa dok = (NotaOdsetkowa)dc.Get(typeof(NotaOdsetkowa));
            DataRepeater1.DataSource = new object[] { dok, dok };

            title = ReportHeader1.Title;
            IdFooter.Caption = String.Format("&nbsp;Data wydruku: {0}<BR>&nbsp;Operator: {1}", Soneta.Types.Date.Today, dc.Context.Session.Login.Operator.Name);

            if (prm.KontoWirtualne && dok.RachunekWirtualny != null)
            {
                ScWirtualny.Visible = true;
                IdBankWirt.Visible = dok.RachunekWirtualny.EwidencjaSP.Rachunek.Bank != null;
                IdSwiftWirt.Visible = !String.IsNullOrEmpty(dok.RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT);
            }
            else
            {
                ScRegularny.Visible = true;
                IdBankReg.Visible = dok.RachunekBankowy.Rachunek.Bank != null;
                IdSwiftReg.Visible = !String.IsNullOrEmpty(dok.RachunekBankowy.Rachunek.SWIFT);
            }

            var kh = dok.Podmiot as Kontrahent;
            if (kh != null && prm.AdresKorespondencyjny && !String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy + kh.AdresDoKorespondencji.Linia1 + kh.AdresDoKorespondencji.Linia2))
            {
                LblAdPodmiot.EditValue = String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy) ? dok.Podmiot.NazwaFormatowana : kh.KorespondencjaNazwaFirmy;
                LblAdAdresLinia1.EditValue = kh.AdresDoKorespondencji.Linia1;
                LblAdAdresLinia2.EditValue = kh.AdresDoKorespondencji.Linia2;
                ScAdresat.Visible = true;
            }
            LblPodmiot.EditValue = dok.Podmiot.NazwaFormatowana;
            LblAdresLinia1.EditValue = dok.Podmiot.Adres.Linia1;
            LblAdresLinia2.EditValue = dok.Podmiot.Adres.Linia2;
            PodstawaPrawnaPodatkowaSection.Visible = dok.OdsetkiOpis.ToString().Contains("Stopa: {0}".TranslateFormat(CaptionAttribute.EnumToString(Soneta.Kasa.OdsetkiStopa.Podatkowe)));
            PodstawaPrawnaHandlowaSection.Visible = (dok.OdsetkiOpis.ToString().Contains("Stopa: {0}".TranslateFormat(CaptionAttribute.EnumToString(Soneta.Kasa.OdsetkiStopa.Handlowe))) 
                || dok.OdsetkiOpis.ToString().Contains("Stopa: {0}".TranslateFormat(CaptionAttribute.EnumToString(Soneta.Kasa.OdsetkiStopa.HandloweMedyczne))));
			PodstawaPrawnaSection.Visible = (!PodstawaPrawnaPodatkowaSection.Visible && !PodstawaPrawnaHandlowaSection.Visible);
        }


        private void onBeforeRowNota(Object sender, EventArgs args)
        {
            if (first)
            {
                first = false;
                ReportHeader1.Title = title + "|ORYGINAŁ";
            }
            else
                ReportHeader1.Title = title + "|KOPIA";
        }


        private void onBeforeRowPozycja(Object sender, RowEventArgs args)
        {
            args.VisibleRow = prm.ZerowePozycje || ((NotaOdsetkowaPozycja)args.Row).Odsetki != Currency.Zero;
        }



	</script>
</head>
<body>
	<form id="NotaOdsetkowa" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" TypeName="Soneta.Kasa.NotaOdsetkowa,Soneta.Kasa" />
	<ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="onBeforeRowNota" RowTypeName="Soneta.Kasa.WezwanieDoZaplaty,Soneta.Kasa" Width="100%" Height="161px">
		<ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true" />
		<cc1:ReportHeader ID="ReportHeader1" Title="Nota odsetkowa|</strong>Numer:<strong> {0}|</strong>Data:<strong> {1}" runat="server" DataMember0="Numer" DataMember1="Data" />

		<em>Konto bankowe:</em><br />
		<ea:Section runat="server" ID="ScWirtualny" Visible="false">
			<ea:DataLabel ID="IdBankWirt" runat="server" Format="{0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.Bank.Nazwa" />
			<ea:DataLabel ID="IdSwiftWirt" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT" />
			<ea:DataLabel ID="DataLabel8" runat="server" DataMember="RachunekWirtualny.Numer" />
		</ea:Section>
		<ea:Section runat="server" ID="ScRegularny" Visible="false">
			<ea:DataLabel ID="IdBankReg" runat="server" Format="{0}<br/>" DataMember="RachunekBankowy.Rachunek.Bank.Nazwa" />
			<ea:DataLabel ID="IdSwiftReg" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekBankowy.Rachunek.SWIFT" />
			<ea:DataLabel ID="DataLabel12" runat="server" DataMember="RachunekBankowy.Rachunek.Numer" />
		</ea:Section>
        <table style="width: 100%; border:hidden">
            <tbody>
                <tr>
                    <td valign="top" width="50%">
		                <p>
			                <em>Odbiorca:</em><br />
			                <ea:DataLabel ID="LblPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia2" runat="server" />
		                </p>
                    </td>
                    <td valign="top" width="50%">
                        <ea:Section runat="server" ID="ScAdresat" Visible="false">
                        <p>
			                <em>Adres korespondencyjny:</em><br />
			                <ea:DataLabel ID="LblAdPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia2" runat="server" />
		                </p>
                        </ea:Section>
                    </td>
                </tr>
            </tbody>
        </table>
		<ea:Section ID="PodstawaPrawnaPodatkowaSection" runat="server">
		    <p>
                Na podstawie ustawy z dnia 29 sierpnia 1997 r. Ordynacja podatkowa (j.t. Dz.U. z 2012 r. poz. 749 z późn. zm.) oraz rozporządzenia Ministra Finansów z dnia 22 sierpnia 2005 r. w sprawie naliczania odsetek za zwłokę oraz opłaty prolongacyjnej, a także zakresu informacji, które muszą być zawarte w rachunkach (Dz. U. Nr 165, poz. 1373 z późn. zm.) wzywamy Państwa do uregulowania, tytułem odsetek za opóźnienie w zapłacie, kwoty <span style="white-space:nowrap"><ea:DataLabel ID="DataLabelPPPodatkowa" runat="server" DataMember="SłownieUpr" /></span> wg poniższego zestawienia:
		    </p>
		</ea:Section>
        <ea:Section ID="PodstawaPrawnaSection" runat="server">
            <p>
                Na podstawie art. 481 ustawy z dnia 23 kwietnia 1964 r. Kodeks cywilny wzywamy Państwa do uregulowania, tytułem odsetek za opóźnienie w zapłacie, kwoty <span style="white-space:nowrap"><ea:DataLabel ID="DataLabelPP" runat="server" DataMember="SłownieUpr" /></span> wg poniższego zestawienia:
            </p>

        </ea:Section>
		<ea:Section ID="PodstawaPrawnaHandlowaSection" runat="server">
            <p>
                Na podstawie Ustawy o przeciwdziałaniu nadmiernym opóźnieniom w transakcjach handlowych z dnia 8 marca 2013 r. wzywamy Państwa do uregulowania, tytułem odsetek za opóźnienie w transakcjach handlowych, kwoty <span style="white-space:nowrap"><ea:DataLabel ID="DataLabelPPHandlowa" runat="server" DataMember="SłownieUpr" /></span> wg poniższego zestawienia:
            </p>

        </ea:Section>
		<ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Kasa.NotaOdsetkowaPozycja,Soneta.Kasa" DataMember="Pozycje" RowsInRow="2" CellBorder="None" OnBeforeRow="onBeforeRowPozycja" Sort="DataDokumentu,NumerDokumentu,Okres.From">
			<Columns>
				<ea:GridColumn runat="server" Width="16" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True" />
				<ea:GridColumn runat="server" ColSpan="8" DataMember="Opis" Caption=" " NoWrap="True" />
				<ea:GridColumn runat="server" Width="10" Align="Center" DataMember="DataDokumentu" Caption="Data" />
				<ea:GridColumn runat="server" Width="10" Align="Center" DataMember="TerminZaplaty" Caption="Termin" />
				<ea:GridColumn runat="server" Width="22" Align="Center" DataMember="Okres" Caption="Okres" />
				<ea:GridColumn runat="server" Width="8" Align="Center" DataMember="Zwloka" Caption="Zwłoka (dni)" />
				<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Procent" Caption="Stopa" />
				<ea:GridColumn runat="server" Align="Right" DataMember="Należność" Total="Info" Format="{0:n}" />
				<ea:GridColumn runat="server" Align="Right" DataMember="Odsetki" Total="Sum" Format="{0:n}" />
			</Columns>
		</ea:Grid>

		<p><ea:DataLabel ID="DataLabel7" runat="server" DataMember="Opis" Bold="False" /></p>
		<p>Prosimy o zrealizowanie płatności zgodnie ze specyfikacją przedstawioną w poniższej tabeli.</p>

		<ea:Grid ID="Grid2" runat="server" DataMember="Platnosci" CellBorder="None">
			<Columns>
				<ea:GridColumn runat="server" Width="20" Align="Center" DataMember="SposobZaplaty" Caption="Sposób zapłaty" />
				<ea:GridColumn runat="server" Width="20" Align="Center" DataMember="Termin" Total="Info" NoWrap="True" />
				<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota" Total="Sum" Format="{0:n}" />
			</Columns>
		</ea:Grid>

		<table id="Table1" cellspacing="0" cellpadding="0" width="90%">
			<tr>
				<td align="right" width="40%">Do zapłaty:</td>
				<td align="right"><ea:DataLabel ID="DataLabel5" runat="server" DataMember="SłownieUpr" /></td>
			</tr>
			<tr>
				<td align="right"><font size="2"><em>Słownie:</em></font></td>
				<td align="right"><font size="2"><em><ea:DataLabel ID="DataLabel6" runat="server" DataMember="Słownie" Bold="False" /></em></font></td>
			</tr>
		</table>
        <p/>
		<cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
			<Subtitles>
				<cc1:FooterSubtitle runat="server" ID="IdFooter" SubtitleType="CenterText" Caption="Operator" Width="50" />
				<cc1:FooterSubtitle runat="server" Caption="Data i podpis osoby uprawnionej do wystawienia dokumentu" Width="50" />
			</Subtitles>
		</cc1:ReportFooter>
	</ea:DataRepeater>
	</form>
</body>
</html>
